#!/bin/bash
set -u

declare ThisScript="${0##*/}"
declare Version=1.0.2
declare -i ErrorCount=0
declare -i Debug=${SDP_DEBUG:-0}
declare LinkTarget=

function msg () { echo -e "$*"; }
# shellcheck disable=SC2317
function dbg () { [[ "$Debug" -eq 0 ]] || msg "DEBUG: $*"; }
function errmsg () { msg "\\nError: ${1:-Unknown Error}\\n"; ErrorCount+=1; }
function bail () { errmsg "${1:-Unknown Error}"; exit "$ErrorCount"; }

msg "Start test [$ThisScript v$Version]: Load checkpoint man page."

# shellcheck disable=SC1091
source /p4/common/bin/p4_vars 1 ||\
   bail "Could not do: source /p4/common/bin/p4_vars 1"

LinkTarget=$(readlink "${P4ROOT}")
if [[ "$LinkTarget" == *db1 ]]; then
   msg "Verified: Pre-swap P4ROOT symlink points to db1."
else
   bail "Pre-swap P4ROOT does NOT point to db1. Aborting this test due to unexpected pre-start conditions."
fi

LinkTarget=$(readlink "${P4ROOT%/root}/offline_db")
if [[ "$LinkTarget" == *db2 ]]; then
   msg "Verified: Pre-swap offline_db symlink points to db2."
else
   bail "Pre-swap offline_db symlink does NOT point to db2. Aborting this test due to unexpected pre-start conditions."
fi

msg "Running: refresh_P4ROOT_from_offline_db.sh"
refresh_P4ROOT_from_offline_db.sh ||\
   errmsg "refresh_P4ROOT_from_offline_db.sh reported non-zero exit code in test expecting 0 exit code."

LinkTarget=$(readlink "${P4ROOT}")
if [[ "$LinkTarget" == *db2 ]]; then
   msg "Verified: Post-swap P4ROOT symlink points to db2."
else
   errmsg "Post-swap P4ROOT does NOT point to db2."
fi

LinkTarget=$(readlink "${P4ROOT%/root}/offline_db")
if [[ "$LinkTarget" == *db1 ]]; then
   msg "Verified: Post-swap offline_db symlink points to db1."
else
   bail "Post-swap offline_db symlink does NOT point to db1."
fi

exit "$ErrorCount"
