#------------------------------------------------------------------------------
# Convenience aliases for testing.
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_rebrand/test/env.sh#2 $ $Change: 31752 $'

#------------------------------------------------------------------------------
# Usage:
# cd YourSDPWorkspaceRoot/dev/test
# . ./env.sh
#------------------------------------------------------------------------------

declare _SDP_TEST_HOME=$PWD

#------------------------------------------------------------------------------
# Sync Latest SDP Workspace, and optionally unshelve some changelists.
#
# This assumes a test SDP workspace has a .p4config file containing a setting
# like:
# P4CLIENT=tom_tyler.P4MBPro3.test_sdp_dev
#
# It also assumes P4PORT and P4USER context settings are already defined
# appropriately for accessing the Public Depot, perhaps with a higher level
# .p4config file.
#
# Usage:
#   sl
#   sl 25101 25302
#
# Each call reverts any opened files in the workspace, syncs to the tip, and
# unshelves any listed shelved changelists.  She shelves are expected to be
# in the same workspace as the workspace defined by $_SDP_TEST_HOME, typically
# 'dev' or 'main'.#
#
# ***WARNING***: This worfklow assumes you're not doing any actual editing or
# work in the test workspace, but only using it to get files into the Docker
# test suite for testing there.
#------------------------------------------------------------------------------
function sl () {
   declare p4configFile="$_SDP_TEST_HOME/sdp/.p4config"
   declare changelistsToUnshelve=
   declare cmd=
   declare allOK=1
   [[ $# -ge 0 ]] && changelistsToUnshelve="$*"

   user=$(p4 set -q P4USER)
   if [[ -r "$p4configFile" ]]; then
      ws=$(grep P4CLIENT= sdp/.p4config)
      ws=${ws#*=}
      if [[ -n "$ws" ]]; then
         cmd="p4 -c $ws -s revert //$ws/..."
         echo "Running: $cmd"
         if ! $cmd; then
            echo -e "\\nError: Revert failed, not syncing.\\n"
            return 1
         fi
         cmd="p4 -c $ws -s sync -q --parallel=threads=8"
         echo "Running: $cmd"
         if ! $cmd; then
            echo -e "\\nError: Sync failed, not unshelving.\\n"
            return 1
         fi
         if [[ -n "$changelistsToUnshelve" ]]; then
            for cl in $changelistsToUnshelve; do
               cmd="p4 -c $ws unshelve -s $cl"
               echo "Running: $cmd"
               if ! $cmd; then
                  echo -e "\\nError: unshelve failed for $cl, skipping it.\\n"
                  allOK=0
               fi
            done
            if [[ "$allOK" -eq 1 ]]; then
               echo -e "\\nUnshelving was successful for changes $changelistsToUnshelve."
            else
               echo -e "\\nError: unshelve failed for one or more changelists.\\n"
               allOK=0
            fi
         else
            echo "No shelved changelists specified to unshelve."
         fi
      else
         echo -e "\\nError: Could not determine P4CLIENT value from $p4configFile. Not syncing."
         return 1
      fi
   else
      echo -e "\\nError: Missing $p4configFile.  To use the 'sl' (sync latest)\\nfunction, create a file $p4configFile containing:\\n\\nP4CLIENT=<your_sdp_test_workspace>\\n\\nSee: $p4configFile/$README.md\\n"
      return 1
   fi
}

# Run Docker Tests for CentOS 6
alias dr6='podman run --rm -e TESTOS=centos6 -v $PWD/sdp:/sdp perforce/centos6-sdp /p4/docker_entry.sh'

# Docker Interactive Session for CentOS 6
alias di6='podman run --rm -e TESTOS=cenots6 -v $PWD/sdp:/sdp -it perforce/centos6-sdp /bin/bash'

# Run Docker Tests for CentOS 7
alias dr7='podman run --rm -e TESTOS=centos7 -v $PWD/sdp:/sdp perforce/centos7-sdp /p4/docker_entry.sh'

# Docker Interactive Session for CentOS 7
alias di7='podman run --rm -e TESTOS=centos7 -v $PWD/sdp:/sdp -it perforce/centos7-sdp /bin/bash'

# Run Docker Tests for Rocky Linux 8
alias dr8='podman run --rm -e TESTOS=rocky8 -v $PWD/sdp:/sdp perforce/rocky8-sdp /p4/docker_entry.sh'

# Run Docker Tests for Rocky Linux 9
alias dr9='podman run --rm -e TESTOS=rocky9 -v $PWD/sdp:/sdp perforce/rocky9-sdp /p4/docker_entry.sh'

# Docker Interactive Session for Rocky Linux 8
alias dir8='podman run --rm -e TESTOS=rocky8 -v $PWD/sdp:/sdp -it perforce/rocky8-sdp /bin/bash'

# Docker Interactive Session for Rocky Linux 9
alias di9='podman run --rm -e TESTOS=rocky9 -v $PWD/sdp:/sdp -it perforce/rocky9-sdp /bin/bash'

# Run Docker Tests for Ubuntu 20
alias dru20='podman run --rm -e TESTOS=ubuntu20 -v $PWD/sdp:/sdp perforce/ubuntu20-sdp /p4/docker_entry.sh'

# Run Docker Tests for Ubuntu 22
alias dru22='podman run --rm -e TESTOS=ubuntu22 -v $PWD/sdp:/sdp perforce/ubuntu22-sdp /p4/docker_entry.sh'
alias dru='podman run --rm -e TESTOS=ubuntu22 -v $PWD/sdp:/sdp perforce/ubuntu22-sdp /p4/docker_entry.sh'

# Docker Interactive Session for Ubuntu 20
alias diu20='podman run --rm -e TESTOS=ubuntu20 -v $PWD/sdp:/sdp -it perforce/ubuntu20-sdp /bin/bash'

# Docker Interactive Session for Ubuntu 22
alias diu22='podman run --rm -e TESTOS=ubuntu22 -v $PWD/sdp:/sdp -it perforce/ubuntu22-sdp /bin/bash'
alias diu='podman run --rm -e TESTOS=ubuntu22 -v $PWD/sdp:/sdp -it perforce/ubuntu22-sdp /bin/bash'
