# Welcome

This is a test harness for the Perforce Unix SDP (Server Deployment Package). 
It used to use Vagrant, but has now been converted to use Docker containers (see older
versions of this file for Vagrant instructions).

## Requirements

To use this bundle you will need to download and install the following free tool:

https://docs.docker.com/engine/installation/

If you're not familiar with Docker, it is building up a huge momentum because of its
sweet spot functionality which addresses fast creation of virtual environments and
the ability to ship images with all dependencies between different environments.

https://docs.docker.com/mac/

## Usage

1) Create a workspace named YourID.test_sdp_dev.sdp (replacing YourID with your account name in the Perforce Public Depot). The root directory should be the directory where this README.md file was found, such that it creates the `sdp` folder below this directory and maps some test files in this directory. The `View:` of the workspace should look like this sample:

    View:
        //guest/perforce_software/sdp/dev/... //YourID.test_sdp_dev.sdp/sdp/...

    p4 -s -c YourID.test_sdp_dev sync

3) From the command prompt run run_docker_tests.sh from the root directory of the workspace. The first time 
you run it will take a while as it builds the initial docker images!

    sdp/test/run_docker_tests.sh

## Workflow for testing

### Build an Image

Build your docker image (from workspace root):

Set OS to your desired OS, e.g. `rocky9`, build the podman image.

```
OS=rocky
sdp/test/build_docker_image.sh $OS
```

**STEP 2**: Run All Tests for an OS

To run all tests (useful to get the pass/fail result):

1A) podman run --rm -v $PWD/sdp:/sdp perforce/ubuntu22-sdp /p4/docker_entry.sh
OR
1B) podman run --rm -v $PWD/sdp:/sdp perforce/rocky9 /p4/docker_entry.sh

How to interactively poke around inside the container (run scripts manually):

1A) podman run --rm -v $PWD/sdp:/sdp -it perforce/rocky9-sdp /bin/bash
1B) podman run --rm -it   --privileged   --security-opt label=disable   -v /var/lib/jenkins/workspace/SDP-Dev-Build/sdp:/sdp   -v /sys/fs/cgroup:/sys/fs/cgroup:ro   --tmpfs /tmp   --tmpfs /run   perforce/rocky9 /bin/bash
1C) podman run --rm -it \
  --privileged \
  --security-opt label=disable \
  -v /var/lib/jenkins/workspace/SDP-Dev-Build/sdp:/sdp \
  -v /sys/fs/cgroup:/sys/fs/cgroup:ro \
  --tmpfs /tmp \
  --tmpfs /run \
  --entrypoint /usr/sbin/init \
  perforce/rocky9



2) Run 'su - perforce' to become user perforce (home directory is /p4)
3) cat reset_sdp.sh
4) SECONDS=0; /p4/test_sdp.sh; echo "EC=$?; SECONDS=$SECONDS"

Substitute 'centos7' with 'ubuntu22' or similar to use different Linux distros in above commands.

Convenience Aliases
--------------------
Once you are comfortable with the workflow above, see the env.sh file that
contains shorthands to speed up your workflow.
