#!/bin/bash

# Get Job Header
# Usage: gjh.sh <job>
# where <job> can be specifie as the job name, like SDP-570 or simply 570.

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_rebrand/tools/gjh.sh#3 $ $Change: 31617 $'

declare ThisScript="${0##*/}"
declare JobBaseURL="https://workshop.perforce.com/jobs"
declare Job=
declare JobURL=
declare JobHeader=
declare JobKey="SDP"
declare JobType=
declare TmpDir=

if [[ $# -lt 1 ]]; then
   echo -e "\\nUsage: $ThisScript <Job>\\n\\ne.g.\\n\\t$ThisScript ${JobKey}-570\\n\\n${JobKey}-570 can be shortened to just 570."
   exit 1
fi

TmpDir=$(mktemp -d)

cd "$TmpDir"

for Job in $*; do
   [[ "$Job" =~ ^[0-9]+$ ]] && Job="${JobKey}-$Job"
   JobURL="$JobBaseURL/$Job"
   curl -s -k -O "$JobURL"
   JobHeader=$(grep 'first-line' $Job|head -1|sed -E -e 's/^.*first-line">//g' -e 's#</span.*$##g' -e 's#<a href=".*">##g' -e 's#</a>##g' -e "s:&#039;:':g" -e "s:&quot;:\":g" -e "s:&lt;:<:g" -e "s:&gt;:>:g")
   JobType=$(grep -E -A1 'Type.*</dt>' $Job | tail -1 | sed -E -e 's/^.*first-line">//g' -e 's#<.*$##g')

   echo -e "$Job ($JobType): $JobHeader\\n$JobURL\\n"
done

cd "$OLDPWD" || exit 1
rm -rf "$TmpDir"
