#!/bin/bash
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------
export SDP_INSTANCE=${SDP_INSTANCE:-Undefined} 
export SDP_INSTANCE=${1:-$SDP_INSTANCE} 
if [[ $SDP_INSTANCE == Undefined ]]; then 
   echo "Instance parameter not supplied." 
   echo "You must supply the Perforce instance as a parameter to this script." 
   exit 1 
fi 
. /p4/common/bin/p4_vars $SDP_INSTANCE
. /p4/common/bin/backup_functions.sh

LOGFILE=$LOGS/edge_shelf_replicate.log
STATUS="OK: Shelves replicated."
declare -i EXIT_CODE=0
 
P4="$P4BIN -p $P4PORT -u $P4USER"
 
$P4CBIN/p4login
 
# Print shelved files on Edge replica. 
for d in `$P4 -s depots|grep "^info: Depot " |\
   grep -v --perl-regexp "^info: Depot \S+ \d{4}\/\d{2}\/\d{2} (remote|archive|unload) " |\
   cut -d ' ' -f 3`; do
   echo === Started replication of //$d/... at $(date). >> $LOGFILE
   echo Running $P4 changes -s shelved //$d/... >> $LOGFILE
   $P4 changes -s shelved //$d/... | cut -d " " -f 2 | while read cl; do
      echo Running $P4 print //$d/...@=$cl >> $LOGFILE
      $P4 print //$d/...@=$cl > /dev/null
   done

   if [[ $? -ne 0 ]]; then
      STATUS="Error: Replication failed.  Review the log [$LOGFILE]."
      EXIT_CODE=1
   fi
done

echo Edge replication complated at $(date). >> $LOGFILE

mail_log_file "$HOSTNAME $P4SERVER Edge shelf replication Log ($STATUS)"
 
exit $EXIT_CODE
