#!/bin/bash
#------------------------------------------------------------------------------
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------
set -u

#------------------------------------------------------------------------------
# Install in the Triggers table like so:
# Triggers:
# 	SDPInfo command post-user-info "/p4/common/bin/triggers/sdp_info.sh %clientprog%"
#
# This script appends the content of the SDP Version file, /p4/sdp/Version, to
# the 'p4 info' output.
#
# This also appends the content of an optional message-of-the-day (motd) file
# to 'p4 info' output.

declare SDPVersionFile="/p4/sdp/Version"
declare SDPMessageOfTheDayFile="/p4/common/site/config/motd.txt"
declare ClientProg="${1:-}"

echo "$@" >> /tmp/foolog

if [[ "${ClientProg:-}" == "p4" ]]; then
   if [[ -r "$SDPVersionFile" ]]; then
      echo "SDP Version: $(cat "$SDPVersionFile")"
   else
      echo "SDP Version: Unknown; missing SDP Version File: $SDPVersionFile"
   fi

   if [[ -r "$SDPMessageOfTheDayFile" ]]; then
      cat "$SDPMessageOfTheDayFile"
   fi
fi

exit 0
