Sample systemd Configuration
==

Overview
--

This directory contains sample systemd \*.service files to start and stop the Helix Core Server and Broker services using systemd.  A more complete set of templates is deployed to `/p4/common/etc/systemd/system`.

To use the sample \*.service files:

1. For each instance, create your own *p4d__N_.service* file, copying from `/p4/common/etc/systemd/system/p4d_N.service.t` template file to /p4/.  Here _N_ is the instance name, e.g. '2' or 'acme'.  If your instance has a broker, proxy, or other component that is to run on the current machine, create additional files as needed.  See the *p4broker_1.service* file as an example.

2. Modify your \*.service files, changing the Description fields as desired, and setting the ExecStart and ExecStop fields to call appropriate script to start and stop the particular service.  For example, *p4d_1.service* would look like this:

 ```
 [Unit]
 Description=Helix Server Instance 1
 Documentation=http://www.perforce.com/perforce/doc.current/manuals/p4sag/index.html
 Requires=network.target
 After=network.target

 [Service]
 Type=simple
 ExecStart=/p4/1/bin/p4d_1_init start
 ExecStop=/p4/1/bin/p4d_1_init stop
 Environment=OS_INIT_MECHANISM=systemd
 User=perforce

 [Install]
 WantedBy=multi-user.target
 ```

3. As **root**, copy your modified \*service files to the `/etc/systemd/system` directory.

4. As **root**, run commands like these samples, substituting the service name:

 ```
 systemctl daemon-reload
 systemctl enable p4d_1
 systemctl enable p4broker_1
 ```

Enabling the services in this manner causes them to start automatically after a reboot. Enabling a service does not start it. Likewise, you can use `disable` in place of `enable` to make a service require manual start after boot. Disabling a service does not stop it immediately.

5. Verify that you can run the service.  As either the **root** or **perforce** user, exercise the start, stop, and status commannds, such as:

 ```
 systemctl status -l p4d_1
 systemctl status -l p4broker_1
 systemctl start p4d_1
 systemctl start p4broker_1
 systemctl status -l p4d_1
 systemctl status -l p4broker_1
 systemctl stop p4d_1
 systemctl stop p4broker_1
 systemctl status -l p4d_1
 systemctl status -l p4broker_1
 ```

At this point your should be live in action.

Multiple Broker Configurations
--

Sometimes multiple broker configurations are desired, such as a "Down for Maintenance" broker used in place of a standard broker during maintenance, or alternate config enabling an SSL-encrypted pathway to a server that might not yet require SSL encryption.

The service name for the default broker is always `p4broker_N`, where N is the instance name, e.g. `p4broker_1`.  This uses the default broker config file, `/p4/common/config/p4_1.broker.cfg`.  (For special cirsumstances where host-specific broker configuration is required, the default broker will use a /p4/common/config/p4_N.broker.<short-hostname>.cfg if it exists).

When alternate broker configurations are used, each alternate configuration file must have a separate systemd unit file associated with managing that configuration.  The service file must specify a configuration tag name, such as 'ssl' or 'dfm'.  That tag name is used to idenfity both the broker config file and the systemd unit file for that broker.  If the broker config is intended to run concurrently with the standard broker config, it must listen on a different port number than the one specified in the standard config. If it is only intended to run in place of the standard config, as with a 'dfm' config, then it should listen on the same port number as the master server. The systemd service for a service intended to run only during maintenance should not be enabled, and thus only manually started/stopped as part of maintenance window procedures.  (If maintenance procedures involve a reboot of a server machine, you may also want to disable services during maintenance and re-enable them afterward).

For example, to add an SSL broker for instance 1, create a broker config file named `/p4/common/config/p4_1.broker.ssl.cfg`.  That could run concurrently with the standard broker, and so should listen on a different port.

Then, create a systemd unit file that references that config.  That would would be `/etc/systemd/system/p4broker_1_ssl.service`, and would look like this:

 ```
 [Unit]
 Description=Helix Broker Instance 1 using p4_1.broker.ssl.cfg
 Documentation=https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/doc/SDP_Guide.Unix.pdf
 Requires=network.target
 After=network.target

 [Service]
 Type=simple
 ExecStart=/p4/1/bin/p4broker_1_init start ssl
 ExecStop=/p4/1/bin/p4broker_1_init stop ssl
 User=perforce
 Environment=OS_INIT_MECHANISM=systemd

 [Install]
 WantedBy=multi-user.target
 ```

Note that the `ExecStart` and `ExecStop` lines reference the config tag, `ssl` in this example.


