#!/usr/bin/env python

"""
This script will search your server log file and find any proxy servers that are
connecting to the server. The server log file needs to be set to a debug level 1 or
higher in order to record all the commands coming into the server.

Just pass the log file in as  parameter to this script and it will print out a list
of the proxy servers.
"""

import re, sys

def main():
  input = open(sys.argv[1], "r")

  proxylist = []

  for line in input.readlines():
    if re.search(r'\d+\.\d+\.\d+\.\d+\/\d+\.\d+\.\d+\.\d+', line):
      def rep(mo):
        return '%s' % (mo.group(1))
      line = re.sub(r'.* (\d+\.\d+\.\d+\.\d+)\/\d+\.\d+\.\d+\.\d+ .*', rep, line)
      if line not in proxylist:
        proxylist.append(line)

  input.close()

  for proxy in proxylist:
    print(proxy)

if __name__ == "__main__":
  main()
