#!/usr/bin/env python
#
# This script requires the pytop module.
# You can get it with "pip install pyotp"
# Source: https://github.com/pyotp/pyotp
#
# This script generates a key for a user and stores the key in the Perforce server.

import pyotp
import os
import re
import sys
import subprocess

# This user should have at least admin access and an unlimited login
p4admin = os.environ['P4USER'] 
# This is the Perforce server where user's password and keys are stored.
authserver = "localhost:1667"
domain = "company.com"

user = sys.argv[1]

key = pyotp.random_base32()
os.system("p4 -u %s -p %s key %s %s" % (p4admin, authserver, user, key))
totp = pyotp.TOTP(key)
uri = totp.provisioning_uri("%s@%s" % (user, domain))
print("http://chart.apis.google.com/chart?cht=qr&chs=250x250&chl=%s" % uri)
print("Key: %s" % key)
