# -*- encoding: UTF8 -*-
# Test harness for P4Triggers.py and a sub-class thereof

"""
Test script for P4Triggers framework
"""

from __future__ import print_function

import sys
import unittest
import os
import re

import P4
from p4testutils import TestCase, P4Server, localDirectory, create_file, append_to_file

parent_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, parent_dir)
import P4Triggers

LOGGER_NAME = "TestP4Triggers"
LOG_FILE = "log-TestP4Triggers.log"


class SampleTrigger(P4Triggers.P4Trigger):
    """See module doc string for details"""

    def __init__(self, *args, **kwargs):
        P4Triggers.P4Trigger.__init__(self, **kwargs)
        self.parse_args(__doc__, args)

    def add_parse_args(self, parser):
        """Specific args for this trigger - also calls super class to add common trigger args"""
        parser.add_argument('-c', '--config-file', default=None,
                            help="Configuration file for trigger. Default: CheckFixes.yaml")
        parser.add_argument('change', help="Change to validate - %%change%% argument from triggers entry.")
        super(SampleTrigger, self).add_parse_args(parser)


class TestP4Triggers(TestCase):
    def __init__(self, methodName='runTest'):
        super(TestP4Triggers, self).__init__(LOGGER_NAME, LOG_FILE, methodName=methodName)

    def setUp(self):
        pass

    def tearDown(self):
        pass


    def testP4Triggers(self):
        """check that fixes are appropriate controlled"""

        trig_args = ["-p", "testport", "-u", "testuser", "99"]
        trig = SampleTrigger(*trig_args)
        self.assertTrue('p4triggers.log' in trig.options.log)
        self.assertEqual('99', trig.options.change)
        self.assertEqual('testport', trig.options.port)
        self.assertEqual('testuser', trig.options.p4user)

        trig_args = ["-p", "testport", "-u", "testuser", "-L", "mylog.log", "99"]
        trig = SampleTrigger(*trig_args)
        self.assertEqual('mylog.log', trig.options.log)
        self.assertEqual('99', trig.options.change)

        os.environ["LOGS"] = "/tmp"
        trig_args = ["-p", "testport", "-u", "testuser", "99"]
        trig = SampleTrigger(*trig_args)
        self.assertTrue('p4triggers.log' in trig.options.log)
        self.assertEqual('99', trig.options.change)

        trig_args = ["-p", "testport", "-u", "testuser", "-L", "mylog.log", "99"]
        trig = SampleTrigger(*trig_args)
        self.assertEqual('mylog.log', trig.options.log)
        self.assertEqual('99', trig.options.change)

if __name__ == '__main__':
    unittest.main()
