#!/bin/bash
set -u

# Make it so user has a password.
# Start state: Bruno may or may not already have a password set.
# Just attempt to set it and ignore errors if already set.

declare SDPInstance=${1:-${SDP_INSTANCE:-1}}

# shellcheck disable=SC1091
source /p4/common/bin/p4_vars "$SDPInstance"

echo "As user $P4USER, setting password for user bruno."
yes "$(cat "$SDP_ADMIN_PASSWORD_FILE")" | p4 -s passwd bruno

echo "Logging in bruno after password change."
p4 login bruno
