#!/bin/bash
set -u

declare ThisScript="${0##*/}"
declare Version=1.0.1
declare -i ErrorCount=0
declare -i ExitCode=0
declare -i Debug=${SDP_DEBUG:-0}

function msg () { echo -e "$*"; }
function dbg () { [[ "$Debug" -eq 0 ]] || msg "DEBUG: $*"; }
function errmsg () { msg "\\nError: ${1:-Unknown Error}\\n"; ErrorCount+=1; }
function bail () { errmsg "${1:-Unknown Error}"; exit "$ErrorCount"; }

msg "Start test [$ThisScript v$Version]: Load checkpoint man page."

msg "Running: load_checkpoint.sh -man"
load_checkpoint.sh -man
ExitCode=$?

exit "$ExitCode"
