﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Seapine.SurroundSCM.API;
using Perforce.P4; 

namespace Surround_To_Perforce
{
    public partial class Login : Form
    {
        public SSCMContext context;
        public Perforce.P4.Connection con;
        public Perforce.P4.Server server = null;
        public Perforce.P4.Repository rep = null;

        public Login()
        {
            InitializeComponent();
        }

        unsafe private void btnConnect_Click(object sender, EventArgs e)
        {

            if (String.IsNullOrEmpty(txtServerAddress.Text) || String.IsNullOrEmpty(txtPort.Text) || String.IsNullOrEmpty(txtUsername.Text))
            {
                MessageBox.Show("Please enter all SSCM fields.");
            }
            else
            {
                SSCMResult result = SSCMAPI.Connect(txtServerAddress.Text, // Server Address 
                                                    Convert.ToUInt16(txtPort.Text), // Port number 
                                                    txtUsername.Text, // Username 
                                                    txtPassword.Text, // Password 
                                                    out context);

                string mainline = context.GetMainline();


                if (result.IsOk())
                {
                    groupBox1.BackColor = System.Drawing.Color.Honeydew;

                    string[] mainlines = { };

                    result = SSCMAPI.GetMainlines(context, out mainlines);

                    if (result.IsOk())
                    {

                        foreach (string m in mainlines)
                        {
                            cboSelectMainline.Items.Add(m);
                        }

                        cboSelectMainline.Enabled = true;
                        btnSetMainline.Enabled = true;

                        txtServerAddress.Enabled = false;
                        txtPort.Enabled = false;
                        txtUsername.Enabled = false;
                        txtPassword.Enabled = false;
                        btnConnect.Enabled = false;
                    }
                    else
                    {
                        groupBox2.BackColor = System.Drawing.Color.Salmon;

                        String sError = SSCMAPI.GetLastError(result);
                        MessageBox.Show("Unable to connect: " + sError);
                    }

                }
                else
                {
                    groupBox1.BackColor = System.Drawing.Color.Salmon;

                    String sError = SSCMAPI.GetLastError(result);
                    MessageBox.Show("Unable to connect: " + sError);
                }
            }
        }

        private void btnSetMainline_Click(object sender, EventArgs e)
        {
            if (cboSelectMainline.SelectedIndex > -1)
            {
                groupBox2.BackColor = System.Drawing.Color.Honeydew;
                context.SetMainline(cboSelectMainline.SelectedItem.ToString());
                cboSelectMainline.Enabled = false;
                btnSetMainline.Enabled = false;
                btnBegin.Enabled = true;

            }
            else
            {
                groupBox2.BackColor = System.Drawing.Color.Salmon;
                MessageBox.Show("Please select a Mainline.");
            }

        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            if (context != null)
                SSCMAPI.Disconnect(context);

            if (con != null)
                con.Disconnect();

            this.Close();
        }

        private void btnBegin_Click(object sender, EventArgs e)
        {
            StatusLog sl = new StatusLog(context, rep);
            sl.ShowDialog();
        }

        private void btnConnectP4_Click(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(txtP4Address.Text) || String.IsNullOrEmpty(txtP4Port.Text) || String.IsNullOrEmpty(txtP4Username.Text) || String.IsNullOrEmpty(txtP4ClientName.Text))
            {
                MessageBox.Show("Please enter all P4 fields.");
            }
            else
            {
                server = new Perforce.P4.Server(new Perforce.P4.ServerAddress(txtP4Address.Text + ":" + txtP4Port.Text));
                rep = new Perforce.P4.Repository(server);
                con = rep.Connection;

                con.UserName = txtP4Username.Text;
                con.Client = new Perforce.P4.Client();
                con.Client.Name = txtP4ClientName.Text;

                bool result = con.Connect(null);

                if (result == true)
                {
                    groupBox3.BackColor = System.Drawing.Color.Honeydew;
                }

                //Perforce.P4.Credential cred = con.Login(txtPassword.Text, null, null);

            }
        }

    }
}
