﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Seapine.SurroundSCM.API;
using Perforce.P4;
using System.Diagnostics;
using System.IO; 

namespace Surround_To_Perforce
{
    public partial class StatusLog : Form
    {
        public StatusLog(SSCMContext context, Perforce.P4.Repository rep)
        {
            InitializeComponent();

            try
            {
                // Make sure you're conncted to P4
                Process.Start("LoginP4.bat").WaitForExit();

                // Create a new depot to stand as the mainline
                //Process.Start("CreateDepot.bat " + context.GetMainline());
                Process.Start("cmd.exe", "/c CreateDepot.bat " + context.GetMainline());
                
                #region // First gather all of the branches and branch paths for the Mainline

                // Gather branch information from Surround SCM
                SSCMBranch[] branchArray = new SSCMBranch[0];
                SSCMAPI.GetBranches(context, true, out branchArray);

                List<SSCMBranch> branchList = new List<SSCMBranch> { };  // List of branches and their information
                List<string> branchPathList = new List<string> { }; // List of Parent|Child branch pairs

                foreach (SSCMBranch b in branchArray)
                {
                    SetProgressText("Processing branch: " + b.GetName());
                    branchList.Add(b);

                    branchPathList.Add(b.GetName());
                }

                for (int i = 0; i < branchList.Count(); i++)
                {
                    Array.Clear(branchArray, 0, branchArray.Length);
                    context.SetBranch(branchList.ElementAt(i).GetName());

                    SSCMAPI.GetBranches(context, true, out branchArray);

                    foreach (SSCMBranch branch in branchArray)
                    {
                        SetProgressText("Processing branch: " + branch.GetName());
                        branchList.Add(branch);

                        SetProgressText("Processing branch path: " + branchList.ElementAt(i).GetName() + "|" + branch.GetName());
                        branchPathList.Add(branchList.ElementAt(i).GetName() + "|" + branch.GetName());
                    }
                }

                // Get the SSCM File Directory to the P4 Client Directory


                #endregion

                #region Now that we have all of the branches, go through and pull together the repository and file structure for each baseline branch
                foreach (SSCMBranch br in branchList)
                {

                   
                }
                #endregion

                #region old code
                SSCMFile[] fileArr = new SSCMFile[0];
                SSCMAPI.SearchFilesByRegex(context, ".*", out fileArr);

                foreach (SSCMFile f in fileArr)
                {

                    SetProgressText("Processing file: " + f.GetName());

                    FileHistoryItem[] history = new FileHistoryItem[0];
                    SSCMAPI.FileHistoryByVersion(context, f.GetRepository(), f.GetName(), true, true, Seapine.SurroundSCM.API.FileAction.AllActions, 1, Convert.ToInt32(f.GetVersion()), out history);
                    SetProgressText("============================================");
                    foreach (FileHistoryItem fhi in history)
                    {
                        SetProgressText("File Action: " + fhi.GetFileAction());
                        SetProgressText("Timestamp: " + fhi.GetTimestamp());
                        SetProgressText("Comments: " + fhi.GetComment());

                    }
                    SetProgressText("============================================");
                }
                #endregion

            }
            catch (Exception ex)
            {
                SetProgressText("Error caught during execution: " + ex.Message);
            }

        }

        public static bool CreateBranch(String branch_id, String username, Perforce.P4.Repository rep)
        {
            try
            {
                var branch = new Perforce.P4.BranchSpec(branch_id, username, DateTime.Now, DateTime.Now, "Created by Surround SCM to P4 migration tool.", true, null, null, null);
                var created = rep.CreateBranchSpec(branch);
            }
            catch (Exception e)
            {
                Console.WriteLine("Unknown exception calling Perforce.");
                Console.Write(e.Message);
                return false;
            }

            return true;
        }

        private void btnDone_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void SetProgressText(string newText)
        {
            txtProgress.Text = txtProgress.Text + Environment.NewLine + newText;
        }
    }
}
