#!/bin/bash
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
set -u

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_c2s/Server/Unix/p4/common/bin/gen_default_broker_cfg.sh#2 $ $Change: 31472 $'

# Generate an SDP instance-specific variant of the generic
# P4Broker config file.  Display to standard output.

# Usage#
# cd /p4/common/bin
# gen_default_broker_cfg.sh SDP_INSTANCE > /tmp/p4broker.cfg.ToBeReviewed
#
# The final p4broker.cfg should end up here:
# /p4/common/config/p4_${SDP_INSTANCE}.${SERVERID}.broker.cfg

declare autotune=0
export SDP_INSTANCE=${1:-Unset} 

if [[ "$SDP_INSTANCE" == Unset ]]; then 
   echo "Instance parameter not supplied." 
   echo "You must supply the SDP instance as a parameter to this script." 
   exit 1 
fi 

# shellcheck disable=SC1091
source /p4/common/bin/p4_vars "$SDP_INSTANCE"
# shellcheck disable=SC1091
source /p4/common/bin/backup_functions.sh

if [[ -r "$P4ROOT/db.config" ]]; then
   copy_jd_table "db.config" "$P4ROOT"
   # shellcheck disable=SC2154
   autotune=$("$P4DBIN" -r "$JDTmpDir" -cshow | "$GREP" net.autotune)
   remove_jd_tables

   if [[ -n "$autotune" ]]; then
      autotune=${autotune##* = }
   else
      autotune=0
   fi
fi

if [[ "$autotune" == 0 ]]; then
   $P4BROKERBIN -C | sed -e "s#/p4/broker/.p4tickets#$P4TICKETS#g" \
      -e "s#/p4/broker#$P4HOME/bin#g" \
      -e "s#broker.log;#\"$LOGS/p4broker.log\";#g" \
      -e "s#1667#$P4BROKERPORT#g" \
      -e "s#localhost:1666#$P4PORT#g" \
      -e "s/perforce-admins@example.com;/\"$MAILTO\";/g"
else
   $P4BROKERBIN -C | sed -e "s#/p4/broker/.p4tickets#$P4TICKETS#g" \
      -e "s#/p4/broker#$P4HOME/bin#g" \
      -e "s#broker.log;#\"$LOGS/p4broker.log\";#g" \
      -e "s#1667#$P4BROKERPORT#g" \
      -e "s#localhost:1666#$P4PORT#g" \
      -e "s#server=1#server=1,net.autotune=$autotune#g" \
      -e "s/perforce-admins@example.com;/\"$MAILTO\";/g"
fi
