#!/usr/bin/env bash
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_c2s/Server/Unix/p4/common/bin/run_if_master.sh#2 $ $Change: 31472 $'

instance=${1:-${SDP_INSTANCE:-UnsetSDPInstance}}
[[ "$instance" == UnsetSDPInstance ]] && \
   { echo "Instance parameter required unless SDP_INSTANCE is defined."; exit 1; }

shift
# shellcheck disable=SC1091
source /p4/common/bin/p4_vars "$instance"
# shellcheck disable=SC1091
source /p4/common/bin/backup_functions.sh
set_vars

if [[ "$P4REPLICA" == "FALSE" ]] && [[ "$EDGESERVER" -eq 0 ]]; then
   exec "$@"
fi
