#==============================================================================

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_c2s/Server/Unix/p4/common/lib/libYAML.sh#2 $ $Change: 31472 $'

#------------------------------------------------------------------------------
# This routine reads in a YAML config file (with fixed 2-space indentation)
# and creates bash string and array variables from the YAML data, with a
# prefix (e.g. "$config_") assigned to each variable name.
#
# For sample usage and output, see: /p4/common/test/yaml/test_parse_yaml.sh.
#
# This is based on software acquired from:
# https://gist.github.com/pkuczynski/8665367
# and https://gist.github.com/epiloque/8cf512c6d64641bde388#file-config-yml-L1

parse_yaml () {
    local prefix=$2
    local s
    local w
    local fs
    s='[[:space:]]*'
    w='[a-zA-Z0-9_]*'
    fs="$(echo @|tr @ '\034')"
    sed -ne "s|^\($s\)\($w\)$s:$s\"\(.*\)\"$s\$|\1$fs\2$fs\3|p" \
        -e "s|^\($s\)\($w\)$s[:-]$s\(.*\)$s\$|\1$fs\2$fs\3|p" "$1" |
    awk -F"$fs" '{
    indent = length($1)/2;
    vname[indent] = $2;
    for (i in vname) {if (i > indent) {delete vname[i]}}
        if (length($3) > 0) {
            vn=""; for (i=0; i<indent; i++) {vn=(vn)(vname[i])("_")}
            printf("%s%s%s=(\"%s\")\n", "'"$prefix"'",vn, $2, $3);
        }
    }' | sed 's/_=/+=/g'
}
