#!/bin/bash

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_c2s/Server/test/snippets/test_set_DO_PARALLEL_CHECKPOINTS_threads.sh#2 $ $Change: 31472 $'

declare Threads=
declare -i DoParallelCheckpoints
export P4D_VERSION=2022.2.999999

function show_result () {
   local dpc=${1:-}
   local threads=${2:-}
   if [[ "$DoParallelCheckpoints" -eq 1 ]]; then
      printf "   %-3s    |           %-11s   |  %-3s\n" YES "$dpc" "$threads"
   else
      printf "   %-3s    |           %-11s   |  %-3s\n" NO "$dpc" "$threads"
   fi
}

printf " Parallel | DO_PARALLEL_CHECKPOINTS | Threads\n"
printf "  Enabled |          Value          |  Value \n"
printf " ---------|-------------------------|--------\n"


Threads=UNSET
unset DO_PARALLEL_CHECKPOINTS
source set_DO_PARALLEL_CHECKPOINTS_threads.snippet
show_result "$DO_PARALLEL_CHECKPOINTS" "$Threads"

Threads=UNSET
export DO_PARALLEL_CHECKPOINTS=0
source set_DO_PARALLEL_CHECKPOINTS_threads.snippet
show_result "$DO_PARALLEL_CHECKPOINTS" "$Threads"

Threads=UNSET
export DO_PARALLEL_CHECKPOINTS=1
source set_DO_PARALLEL_CHECKPOINTS_threads.snippet
show_result "$DO_PARALLEL_CHECKPOINTS" "$Threads"

Threads=UNSET
export DO_PARALLEL_CHECKPOINTS=2
source set_DO_PARALLEL_CHECKPOINTS_threads.snippet
show_result "$DO_PARALLEL_CHECKPOINTS" "$Threads"

Threads=UNSET
export DO_PARALLEL_CHECKPOINTS=3
source set_DO_PARALLEL_CHECKPOINTS_threads.snippet
show_result "$DO_PARALLEL_CHECKPOINTS" "$Threads"

Threads=UNSET
export DO_PARALLEL_CHECKPOINTS=04
source set_DO_PARALLEL_CHECKPOINTS_threads.snippet
show_result "$DO_PARALLEL_CHECKPOINTS" "$Threads"

Threads=UNSET
export DO_PARALLEL_CHECKPOINTS=0016
source set_DO_PARALLEL_CHECKPOINTS_threads.snippet
show_result "$DO_PARALLEL_CHECKPOINTS" "$Threads"

Threads=UNSET
export DO_PARALLEL_CHECKPOINTS=Yes
source set_DO_PARALLEL_CHECKPOINTS_threads.snippet
show_result "$DO_PARALLEL_CHECKPOINTS" "$Threads"

Threads=UNSET
export DO_PARALLEL_CHECKPOINTS=Enabled
source set_DO_PARALLEL_CHECKPOINTS_threads.snippet
show_result "$DO_PARALLEL_CHECKPOINTS" "$Threads"

Threads=UNSET
export DO_PARALLEL_CHECKPOINTS=Off
source set_DO_PARALLEL_CHECKPOINTS_threads.snippet
show_result "$DO_PARALLEL_CHECKPOINTS" "$Threads"

[[ "$DoParallelCheckpoints" -eq 1 ]] && :

printf " Parallel | DO_PARALLEL_CHECKPOINTS | Threads\n"
