#!/usr/bin/env python

"""
Usage:
	python protect_groups.py remove_groups.txt p4.protect

This script will drop all lines in the protect table that have a group referenced from the file
groups.txt passed into the script. The list of groups to drop is passed in as the first parameter
and the protect table is passed in as the 2nd parameter.

remove_groups.txt is generated using protect_groups.py - See that script for details.

Run "p4 protect -o > p4.protect" to generate the protections table.

You can redirect the output of this script to a file called new.p4.protect and then you can compare
the original p4.protect and the new.p4.protect. If everything looks okay, you can update the protections
table by running:

p4 protect -i < new.p4.protect

"""

import re
import sys


def main():
  p4groups = []

  groups = open(sys.argv[1], "r")
  protect = open(sys.argv[2], "r")

  for group in groups.readlines():
    group = group.rstrip()
    group = group.lower()
    p4groups.append(group)

  for line in protect.readlines():
    line = line.rstrip()
    origline = line
    line = line.lower()
    match = re.match(".*group (.*) \* .*", line)
    if match:
      if match.group(1).lower() in p4groups:
        continue
      else:
        print(origline)
    else:
      print(origline)

  groups.close()
  protect.close()


###############################################################################
# main
if __name__ == "__main__":
  main()
