#!/bin/bash
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_c2s/Unsupported/Maintenance/email.sh#2 $ $Change: 31472 $'

# This script is used to send email to all of your Perforce users.
# Create a file called message.txt that contains the body of your message.
# Then call this script and pass the subject in quotes as the only parameter.

# It makes a copy of the previous email list, then call make_email_list.py
# to generate a new one from Perforce.

# The reason for making the copy is so that you will always have an email list that
# you can use to send email with. Just comment out the call to python mmake_email_list.py
# below, and run the script. It will use the current list to send email from. This is
# handy in case your server goes off-line.

cp emaillist.txt emaillist.prev
python make_email_list.py
python pymail.py -t emaillist.txt -s "$1" -i message.txt
