#!/usr/bin/env python

import os
import sys
import getopt
import smtplib
from email.mime.text import MIMEText
import sdputils

if len(sys.argv) > 1:
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()

fromAddr = utils.get('administrator')
replyToAddr = ''
mailSMTPhost = utils.get('mailhost')
mailSMTPport = int(utils.get('mailport'))
mailsecure = int(utils.get('mailsecure'))
if mailsecure:
  mailUser = utils.get('mailuser')
  mailPass = utils.get('mailpass')

def usage():
  print("pymail.py -t <to-address or address file> -s <subject> -i <input file>")
  sys.exit()


def mail(inputfile, subject, toAddr):
  fp = open(inputfile, 'rb')
  msg = MIMEText(fp.read())
  fp.close()

  msg['Subject'] = subject
  msg['From'] = fromAddr
  if (len(replyToAddr)):
    msg.add_header('reply-to', replyToAddr)
  msg['To'] = toAddr

  try:
    print("Sending mail to: %s" % toAddr)
    s = smtplib.SMTP(mailSMTPhost, mailSMTPport)
    if mailsecure:
      s.starttls()
      s.login(mailUser, mailPass)
    s.sendmail(msg['From'], msg['To'], msg.as_string())
    s.quit()
  except smtplib.SMTPException:
    print("Error: unable to send email to %s." % msg['To'])


def main(argv):
  inputfile = ''
  subject = ''
  toAddr = ''
  addressfile = ''

  try:
    opts, args = getopt.getopt(argv, "ht:s:i:")
  except:
    usage()

  for opt, arg in opts:
    if opt == '-h':
      usage()
    elif opt == '-i':
      inputfile = arg
    elif opt == '-t':
      toAddr = arg
      if os.path.isfile(arg):
        addressfile = arg
    elif opt == '-s':
      subject = arg

  if (len(subject) == 0 or len(toAddr) == 0 or len(inputfile) == 0):
    usage()

  if addressfile:
    addresses = open(addressfile, "r")
    for address in addresses.readlines():
      mail(inputfile, subject, address.strip())
    addresses.close()
  else:
    mail(inputfile, subject, toAddr)


if __name__ == "__main__":
  main(sys.argv[1:])
