#!/usr/bin/env python

"""
This module is a convenience for other modules in this directory
"""

# Python 2.7/3.3 compatibility.
from __future__ import print_function

import os
import sys
import platform

class SDPUtils:
  def __init__(self, sdp_instance):
    self.sdp_instance = sdp_instance

    # Python 2.7/3.3 compatibility.
    if sys.version_info[0] >= 3:
      import configparser
      self.rawconfig = configparser.RawConfigParser()
    else:
      import ConfigParser
      self.rawconfig = ConfigParser.RawConfigParser()

    ##########################################################################
    #####                                #####
    #####  CONFIGURATION VARIABLES: Modify in maintenance.cfg as needed. #####
    #####                                #####
    self.rawconfig.read('maintenance.cfg')
    self.server = os.environ.get('P4PORT')
    self.p4user = os.environ.get('P4USER')

    if platform.system() == "Windows":
      self.p4 = "p4.exe -p %s -u %s" % (self.server, self.p4user)
    else:
      self.p4 = "/p4/%s/bin/p4_%s -u %s -p %s" % (self.sdp_instance, self.sdp_instance, self.p4user, self.server)
      self.p4_noport = "/p4/%s/bin/p4_%s -u %s" % (self.sdp_instance, self.sdp_instance, self.p4user)

  def get(self, varname):
    return self.rawconfig.get(self.sdp_instance, varname)

  def login(self):
    os.system('%s -p %s login -a < /p4/common/config/.p4passwd.p4_%s.admin' % (self.p4_noport, self.server, self.sdp_instance))

