#!/bin/bash
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_c2s/Unsupported/Maintenance/server_status.sh#2 $ $Change: 31472 $'

# This script is used to check the status of all the instances running on this machine. 
# It can handle named and numbered instances.

echo "==========================================";
echo "|   SDP Server Status for $totalServers instances    |";
echo "==========================================";
FILES_LIST="$(ls /p4/*/root/db.have 2>/dev/null)"
for file in $FILES_LIST; do
    serverName=$(echo $file | cut -f3 -d/)
    /p4/$serverName/bin/p4d_$serverName\_init status | grep ^ServerID:
    /p4/$serverName/bin/p4d_$serverName\_init status | grep uptime
    /p4/$serverName/bin/p4d_$serverName\_init status | grep root
    /p4/$serverName/bin/p4d_$serverName\_init status | grep version
    echo "==========================================";
done
