#!/usr/bin/env python

"""
This script will set the password for a user to the value set in the password
variable in the main function.

The name of the user to set the password for is passed as a parameter to the file.

Usage:
	python setpass.py [instance] user
	
instance defaults to 1 if not given.
"""

from subprocess import *
import sys
import time
import sdputils
verbose = "1"

if len(sys.argv) > 2:   # not usual arg
    SDP_INSTANCE = str(sys.argv[1])
else:
    SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()

defaultpass = (utils.get('default_user_password'))


###############################################################################
def log(msglevel="DEBUG", message=""):
    if msglevel == "TEST":
        print("Running in test mode. Command run would have been:\n", message)
    elif msglevel == "ERROR":
        print(message)
        sys.exit(1)
    elif (verbose == "3"):
        print(message)
    elif (verbose == "2" and msglevel == "INFO"):
        print(message)


###############################################################################
def setpassword(user):
    try:
        cmd = ' passwd %s' % (user)
        pipe = Popen(p4 + cmd, shell=True, stdin=PIPE, stdout=PIPE, stderr=PIPE, universal_newlines=True)
        stderr = pipe.stdin.write(defaultpass)
        pipe.stdin.flush()
        time.sleep(2)
        stderr = pipe.stdin.write(defaultpass)
        pipe.stdin.flush()
        pipe.stdin.close()
        if pipe.wait() != 0:
            log("ERROR", "Password reset failed.\n%s%s generated the following error: %s" % (p4, cmd, stderr))
    except OSError as err:
        log("ERROR", "Execution failed: %s" % (err))


def main():
    if len(sys.argv) < 2:
        print("Read the usage section at the top of the script for required parameters.")
        sys.exit(1)
    if len(sys.argv) > 2:
        user = sys.argv[2]
    else:
        user = sys.argv[1]

    setpassword(user)


###############################################################################
if __name__ == '__main__':
    main()
