#!/usr/bin/env python

"""
This script will unload labels that have not been accessed since the number
of weeks specified in the removedate string below.
"""

# Python 2.7/3.3 compatibility.
from __future__ import print_function

import os
import datetime
import sys
import sdputils

if len(sys.argv) > 1:
  SDP_INSTANCE = str(sys.argv[1])
else:
  SDP_INSTANCE = '1'

utils = sdputils.SDPUtils(SDP_INSTANCE)
p4 = utils.p4
utils.login()
cfgweeks = utils.get('weeks')

def main():
  days = cfgweeks * 7
  removedate = (datetime.date.today() - datetime.timedelta(days)).strftime("%Y/%m/%d")
  command = ('%s unload -f -L -z -al -d %s') % (p4, removedate)
  os.system(command)

###############################################################################
# main
if __name__ == '__main__':
  main()
