#!/bin/sh

#------------------------------------------------------------------------------
# Version ID Block. Relies on +k filetype modifier.
# VersionID='$Id: //p4-sdp/dev_c2s/Unsupported/Samples/bin/htd_move_logs.sh#2 $ $Change: 31472 $'

# Script to compress and move Helix Server structured audit logs
#
# (C) 2015 Perforce Software
#
# Implementation assumptions and suggestions:
# - Assumes the rotated log files are named audit-nnn.csv
# - Do NOT configure your log files to be placed in $P4ROOT
# - Set TARGETDIR below
#
export SDP_INSTANCE=${SDP_INSTANCE:-Undefined}
export SDP_INSTANCE=${1:-$SDP_INSTANCE}
if [[ $SDP_INSTANCE == Undefined ]]; then
   echo "Instance parameter not supplied."
   echo "You must supply the Perforce instance as a parameter to this script."
   exit 1
fi

source /p4/common/bin/p4_vars $SDP_INSTANCE

HTDLOG=${P4LOGS}/htd_move.log
TARGETDIR=/data1/ingest

$P4BIN logrotate -l ${P4LOGS}/audit.csv

cd ${P4LOGS}
FILEID=${HOSTNAME}.${P4SERVER}.$(date +%Y-%m-%d-%H-%M-%S-%N)

numfiles=$(ls audit-*.csv 2> /dev/null | wc -l)
echo "$numfiles log files found" > $HTDLOG
if [ "$numfiles" -gt 0 ];then
  for EACH in `ls audit-*.csv`
  do
    mv $EACH ${EACH}.${FILEID}
    echo -n "${EACH}.${FILEID}: Compressing... " >> $HTDLOG
    gzip -9 ${EACH}.${FILEID}
    echo -n "Moving..." >> $HTDLOG
    mv ${EACH}.${FILEID}.gz ${TARGETDIR}
  done
fi
echo "Done!" >> $HTDLOG
#
# END

