#!/usr/bin/env python
#==============================================================================
# Copyright and license info is available in the LICENSE file included with
# the Server Deployment Package (SDP), and also available online:
# https://swarm.workshop.perforce.com/projects/perforce-software-sdp/view/main/LICENSE
#------------------------------------------------------------------------------
#
# This script modifies the description of the change form for the Perforce users listed in the
# submit_form_1_users group.
#
# Trigger table entry:
#	submitform1 form-out change "/p4/common/bin/triggers/submit_form_1.py %formfile% %user%"

import os
import sys
import re

###############################################################################
def main():
  formfile = sys.argv[1]
  triggeruser = sys.argv[2]
  triggeruser = triggeruser.strip()

  desc_repl = """
  Incident:

  Description:

  Reviewed by:
  """

  for group in os.popen("p4 groups -i %s" % (triggeruser)).readlines():
    group = group.strip()
    if (group.find("submit_form_1_users") == 0):
      with open(formfile) as f:
        content = f.read()

      content = content.replace("<enter description here>", desc_repl)

      with open(formfile, "w") as f:
        f.write(content)

  sys.exit(0)

###############################################################################
if __name__ == '__main__':
  main()
