#!/bin/bash
set -u

# Version ID Block. Relies on +k filetype modifier.
#------------------------------------------------------------------------------
# shellcheck disable=SC2016
declare VersionID='$Id: //p4-sdp/dev_c2s/test/bsw/test_script-recover_correct_ckp_5.sh#2 $ $Change: 31472 $'
declare VersionStream=${VersionID#*//}; VersionStream=${VersionStream#*/}; VersionStream=${VersionStream%%/*};
declare VersionCL=${VersionID##*: }; VersionCL=${VersionCL%% *}
declare Version=${VersionStream}.${VersionCL}
[[ "$VersionStream" == r* ]] || Version="${Version^^}"

declare ThisScript="${0##*/}"
declare -i ErrorCount=0
declare -i Debug=${SDP_DEBUG:-0}
declare StandbyHost=bos-helix-02
declare -i StandbyLogCount=0
declare -a StandbyLogList

function msg () { echo -e "$*"; }
function dbg () { [[ "$Debug" -eq 0 ]] || msg "DEBUG: $*"; }
function errmsg () { msg "\\nError: ${1:-Unknown Error}\\n"; ErrorCount+=1; }
function bail () { errmsg "${1:-Unknown Error}"; exit "$ErrorCount"; }

msg "Start test [$ThisScript version $Version]: Confirm standby loads latest paralellel checkpoint even if configured for serial."

# Setup: Create site config dir if needed
mkdir -p /p4/common/site/config
ssh "$StandbyHost" mkdir -p /p4/common/site/config

msg "Configure serial checkpoint on commit and standby."

{
   echo export DO_PARALLEL_CHECKPOINTS=0
   echo KEEPCKPS=2
   echo KEEPJNLS=2
   echo KEEPCKPS=2
} > /p4/common/site/config/p4_1.vars.local

rsync /p4/common/site/config/p4_1.vars.local "$StandbyHost":/p4/common/site/config/p4_1.vars.local ||\
   errmsg "Failed to copy /p4/common/site/config/p4_1.vars.local."

msg "Request checkpoint on standby."
ssh "$StandbyHost" /p4/common/bin/sync_replica.sh 1 ||\
   errmsg "Remote call to sync_replica.sh indicated an error."

StandbyLogList[StandbyLogCount]="/p4/1/logs/sync_replica.log"
StandbyLogCount+=1

msg "Checking for syntax and unbound errors in scripts used in this test on standby host."
for log in "${StandbyLogList[@]}"; do
   msg "Checking for 'unbound variable' in: $StandbyHost:$log"
   ssh -q "$StandbyHost" "grep ':unbound variable' $log" && \
      errmsg "Found 'unbound variable' error in $log"
   msg "Checking for 'syntax error' in: $StandbyHost:$log"
   ssh -q "$StandbyHost" "grep ':syntax error' $log" && \
      errmsg "Found 'syntax error' in $log"
done

exit "$ErrorCount"
